using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgDisplayTransReqsAndSpecIns
	/// </summary>
	public class DlgDisplayTransReqsAndSpecIns : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Button btnOK;
		private System.Windows.Forms.TextBox txtCompatibility;
		private System.Windows.Forms.Label lblCompatibility;
		private gov.va.med.vbecs.GUI.controls.SpecialInstructionsDisplayPanel specialInstructionsDisplayPanel1;
		private System.Windows.Forms.GroupBox grpDisplay;
		private System.Windows.Forms.Label lblPercentage;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="patient"></param>
		public DlgDisplayTransReqsAndSpecIns(BOL.Patient patient)
		{
			if (this.IsPatientDataInUse(patient))
			{
				//Anyone calling trying to raise this form.. Before you Show() for ShowDialog, check 
				//the DialogResult!!!
				this.DialogResult = DialogResult.Abort;
				return;
			}
			else
			{
				// This call is required by the Windows Form Designer.
				InitializeComponent();
				//
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC036.DlgDisplayTransReqsAndSpecIns());
				//
				this.specialInstructionsDisplayPanel1.Patient = patient;
				this.txtCompatibility.Text = patient.CompatibilityPercentage;
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgDisplayTransReqsAndSpecIns));
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.btnOK = new System.Windows.Forms.Button();
			this.txtCompatibility = new System.Windows.Forms.TextBox();
			this.lblCompatibility = new System.Windows.Forms.Label();
			this.specialInstructionsDisplayPanel1 = new gov.va.med.vbecs.GUI.controls.SpecialInstructionsDisplayPanel();
			this.grpDisplay = new System.Windows.Forms.GroupBox();
			this.lblPercentage = new System.Windows.Forms.Label();
			this.grpImage.SuspendLayout();
			this.grpDisplay.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(492, 30);
			this.vbecsLogo1.Title = "Patient Transfusion Requirements and Special Instructions";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 357);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 304);
			this.grpImage.TabIndex = 12;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 1;
			this.pictureBox1.TabStop = false;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Location = new System.Drawing.Point(412, 344);
			this.btnOK.Name = "btnOK";
			this.btnOK.TabIndex = 3;
			this.btnOK.Text = "&OK";
			// 
			// txtCompatibility
			// 
			this.txtCompatibility.AccessibleDescription = "Compatibility Percentage";
			this.txtCompatibility.AccessibleName = "Compatibility Percentage";
			this.txtCompatibility.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtCompatibility.Location = new System.Drawing.Point(148, 12);
			this.txtCompatibility.Name = "txtCompatibility";
			this.txtCompatibility.ReadOnly = true;
			this.txtCompatibility.Size = new System.Drawing.Size(72, 20);
			this.txtCompatibility.TabIndex = 1;
			this.txtCompatibility.Text = "";
			this.txtCompatibility.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// lblCompatibility
			// 
			this.lblCompatibility.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.errError.SetIconAlignment(this.lblCompatibility, System.Windows.Forms.ErrorIconAlignment.MiddleLeft);
			this.lblCompatibility.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.lblCompatibility.Location = new System.Drawing.Point(16, 12);
			this.lblCompatibility.Name = "lblCompatibility";
			this.lblCompatibility.Size = new System.Drawing.Size(132, 20);
			this.lblCompatibility.TabIndex = 1;
			this.lblCompatibility.Text = "Compatibility Percentage";
			this.lblCompatibility.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// specialInstructionsDisplayPanel1
			// 
			this.specialInstructionsDisplayPanel1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.specialInstructionsDisplayPanel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.specialInstructionsDisplayPanel1.Location = new System.Drawing.Point(8, 34);
			this.specialInstructionsDisplayPanel1.Name = "specialInstructionsDisplayPanel1";
			this.specialInstructionsDisplayPanel1.Patient = null;
			this.specialInstructionsDisplayPanel1.Size = new System.Drawing.Size(412, 262);
			this.specialInstructionsDisplayPanel1.TabIndex = 2;
			this.specialInstructionsDisplayPanel1.Load += new System.EventHandler(this.specialInstructionsDisplayPanel1_Load);
			// 
			// grpDisplay
			// 
			this.grpDisplay.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDisplay.Controls.Add(this.lblPercentage);
			this.grpDisplay.Controls.Add(this.txtCompatibility);
			this.grpDisplay.Controls.Add(this.lblCompatibility);
			this.grpDisplay.Controls.Add(this.specialInstructionsDisplayPanel1);
			this.grpDisplay.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.grpDisplay.Location = new System.Drawing.Point(60, 32);
			this.grpDisplay.Name = "grpDisplay";
			this.grpDisplay.Size = new System.Drawing.Size(428, 304);
			this.grpDisplay.TabIndex = 0;
			this.grpDisplay.TabStop = false;
			// 
			// lblPercentage
			// 
			this.lblPercentage.Location = new System.Drawing.Point(220, 12);
			this.lblPercentage.Name = "lblPercentage";
			this.lblPercentage.Size = new System.Drawing.Size(15, 20);
			this.lblPercentage.TabIndex = 13;
			this.lblPercentage.Text = "%";
			this.lblPercentage.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// DlgDisplayTransReqsAndSpecIns
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(492, 373);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpDisplay);
			this.Controls.Add(this.grpImage);
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(500, 400);
			this.Name = "DlgDisplayTransReqsAndSpecIns";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Patient Transfusion Requirements and Special Instructions";
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.grpDisplay, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpImage.ResumeLayout(false);
			this.grpDisplay.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// According to the Locking SDD, we don't want users to see this informtion if it's 
		/// being edited by another user via UC37, or 38
		/// </summary>
		/// <param name="patient"></param>
		/// <returns></returns>
		private bool IsPatientDataInUse(BOL.Patient patient)
		{
			bool lockExists = false;
			BOL.Lock lockCheck = null;

			//01-30-2004 - Lohse's attempt at locking this according to the SDD
			foreach (System.Data.DataRow drSI in patient.SpecialInstructions.Rows)
			{
				lockCheck = BOL.LockManager.GetLock((System.Guid)drSI[Common.VbecsTables.PatientSpecialInstruction.PatientSpecialInstructionGuid],false);

				if (lockCheck.LockExists)
				{
					lockExists = true;
					break;
				}
			}

			if (!lockExists)		//No need to check the TR's if the SI's failed
			{
				foreach(System.Data.DataRow drTR in patient.TransfusionRequirements.Rows)
				{
					lockCheck = BOL.LockManager.GetLock((System.Guid)drTR[Common.VbecsTables.PatientTransfusionRequirement.PatientTransfusionRequirementGuid],false);
		
					if (lockCheck.LockExists)
					{
						lockExists = true;
						break;
					}
				}
			}

			if (lockExists)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC036.PatientInformationLockedByUser(lockCheck.UserName));
			}

			return(lockExists);
		}


		private void specialInstructionsDisplayPanel1_Load(object sender, System.EventArgs e)
		{
		
		}

	}
}

